CONTAINER fx_c4d_obstacle
{
	NAME fx_c4d_obstacle;	
	INCLUDE Texpression;

	GROUP ID_TAGPROPERTIES
	{
		LONG FXOBSTACLE_MATERIAL_SPEC
		{
			CYCLE
			{
				FXOBSTACLE_MATERIAL_SPEC_MASS;
				FXOBSTACLE_MATERIAL_SPEC_DENSITY;
			}
		}
		REAL FXOBSTACLE_MASS { MIN 0; STEP 0.1; }
		REAL FXOBSTACLE_DENSITY { MIN 0; }
		LONG FXOBSTACLE_DYNAMIC_STATE
		{	
			HIDDEN;
			CYCLE
			{
				FXOBSTACLE_DYNAMIC_STATE_STATIC;
				FXOBSTACLE_DYNAMIC_STATE_KINEMATIC;
				//FXOBSTACLE_DYNAMIC_STATE_DYNAMIC;
			}
		}
		LINK FXOBSTACLE_CENTEROFMASS { ACCEPT{Obase;} }	
		
		GROUP SUB_FXOBSTACLE_MATERIAL
		{
			DEFAULT 1;
			REAL FXOBSTACLE_DEACTIVATION		{ MIN 0; STEP 0.1;}
			REAL FXOBSTACLE_DEACTIVATION_ANGULAR	{ MIN 0; UNIT DEGREE;}
		}
	}
	GROUP SUB_FXOBSTACLE_DYNAMICS
	{
		BOOL FXOBSTACLE_DYNAMICS_TRANSFER_TO_ORIG  {}
		BOOL FXOBSTACLE_DYNAMICS_ACTIVE_ON_COLL  {}
		BOOL FXOBSTACLE_DYNAMICS_ACTIVE_ON_VELO  {}
		REAL FXOBSTACLE_DYNAMICS_ACTIVE_ON_VELO_THRESHOLD { MIN 0.0; STEP 0.1;}

		SEPARATOR {LINE;}

		GROUP
		{
			COLUMNS 2;
			LINK FXOBSTACLE_DYNAMICS_INITIAL_DIR	{ ACCEPT{fx_alignment; } }
			BUTTON FXOBSTACLE_DYNAMICS_INITIAL_DIR_SELECTOR {}
		}
		REAL FXOBSTACLE_DYNAMICS_INITIAL_FORCE	{ MIN 0; STEP 0.1;}

		REAL FXOBSTACLE_COLLISION_DAMPING { MIN 0; UNIT PERCENT; MAXSLIDER 100; CUSTOMGUI REALSLIDER; }
		REAL FXOBSTACLE_COLLISION_DAMPING_ANGULAR { MIN 0; UNIT PERCENT; MAXSLIDER 100; CUSTOMGUI REALSLIDER; }
		
		VECTOR FXOBSTACLE_DYNAMICS_FACTOR_LINEAR { MIN 0 0 0; STEP 0.1 0.1 0.1; }
		VECTOR FXOBSTACLE_DYNAMICS_FACTOR_ANGULAR { MIN 0 0 0; STEP 0.1 0.1 0.1; }

		GROUP SUB_FXOBSTACLE_DYNAMICS_CONSTRAINTS
		{			 
			DEFAULT 0;
			IN_EXCLUDE FXOBSTACLE_DYNAMICS_CONSTRAINTS_DAMPING
			{
				NUM_FLAGS 0; INIT_STATE 0; SEND_SELCHNGMSG 0;
				ACCEPT {  fx_constraint_coffee; fx_constraint_particledistance; fx_constraint_particlecount;fx_constraint_volume; fx_constraint_noise; fx_constraint_gradient; fx_constraint_gridvalue; fx_constraint_gridaverage; fx_constraint_voxeldistance; fx_constraint_particle_collision;fx_constraint_particle_property;};
			}
			IN_EXCLUDE FXOBSTACLE_DYNAMICS_CONSTRAINTS_DAMPING_ANGULAR
			{
				NUM_FLAGS 0; INIT_STATE 0; SEND_SELCHNGMSG 0;
				ACCEPT {  fx_constraint_coffee; fx_constraint_particledistance; fx_constraint_particlecount;fx_constraint_volume; fx_constraint_noise; fx_constraint_gradient; fx_constraint_gridvalue; fx_constraint_gridaverage; fx_constraint_voxeldistance; fx_constraint_particle_collision;fx_constraint_particle_property;};
			}
		}
	}
	GROUP SUB_FXOBSTACLE_COLLISION
	{
		BOOL FXOBSTACLE_GHOST {}
		REAL FXOBSTACLE_COLLISION_MARGIN { MIN -0.01; STEP 0.01; }
		
		SEPARATOR {LINE;}
			
		REAL FXOBSTACLE_COLLISION_BOUNCE { MIN 0; UNIT PERCENT; MAXSLIDER 100; CUSTOMGUI REALSLIDER; }
		REAL FXOBSTACLE_COLLISION_FRICTION { MIN 0; UNIT PERCENT; MAXSLIDER 100; CUSTOMGUI REALSLIDER; }
		REAL FXOBSTACLE_COLLISION_FRICTION_ANGULAR { MIN 0; UNIT PERCENT; MAXSLIDER 100; CUSTOMGUI REALSLIDER; }
			
		//SEPARATOR {LINE;}
		
		LONG FXOBSTACLE_COLLISION_ANISOTROPIC_FRICTION_MODE
		{
			HIDDEN;
			CYCLE
			{
				FXOBSTACLE_COLLISION_ANISOTROPIC_FRICTION_MODE_OFF;
				FXOBSTACLE_COLLISION_ANISOTROPIC_FRICTION_MODE_LINEAR;
				FXOBSTACLE_COLLISION_ANISOTROPIC_FRICTION_MODE_ANGULAR;
			}
		}
		BOOL FXOBSTACLE_COLLISION_ANISOTROPIC_FRICTION_AUTO {HIDDEN;}
		VECTOR FXOBSTACLE_COLLISION_ANISOTROPIC_FRICTION {HIDDEN;}
		
		SEPARATOR {LINE;}
		
		LONG FXOBSTACLE_COLLISION_SAMPLE_MODE
		{
			CYCLE
			{
				FXOBSTACLE_COLLISION_SAMPLE_MODE_FIRST;
				FXOBSTACLE_COLLISION_SAMPLE_MODE_ALL;
			}
		}

		GROUP SUB_FXOBSTACLE_COLLISION_CONSTRAINTS
		{			 
			DEFAULT 0;
			IN_EXCLUDE FXOBSTACLE_COLLISION_CONSTRAINTS_BOUNCE
			{
				NUM_FLAGS 0; INIT_STATE 0; SEND_SELCHNGMSG 0;
				ACCEPT {  fx_constraint_coffee; fx_constraint_particledistance; fx_constraint_particlecount;fx_constraint_volume; fx_constraint_noise; fx_constraint_gradient; fx_constraint_gridvalue; fx_constraint_gridaverage; fx_constraint_voxeldistance; fx_constraint_particle_collision;fx_constraint_particle_property;};
			}
			IN_EXCLUDE FXOBSTACLE_COLLISION_CONSTRAINTS_FRICTION
			{
				NUM_FLAGS 0; INIT_STATE 0; SEND_SELCHNGMSG 0;
				ACCEPT {  fx_constraint_coffee; fx_constraint_particledistance; fx_constraint_particlecount;fx_constraint_volume; fx_constraint_noise; fx_constraint_gradient; fx_constraint_gridvalue; fx_constraint_gridaverage; fx_constraint_voxeldistance; fx_constraint_particle_collision;fx_constraint_particle_property;};
			}
			IN_EXCLUDE FXOBSTACLE_COLLISION_CONSTRAINTS_FRICTION_ANGULAR
			{
				NUM_FLAGS 0; INIT_STATE 0; SEND_SELCHNGMSG 0;
				ACCEPT {  fx_constraint_coffee; fx_constraint_particledistance; fx_constraint_particlecount;fx_constraint_volume; fx_constraint_noise; fx_constraint_gradient; fx_constraint_gridvalue; fx_constraint_gridaverage; fx_constraint_voxeldistance; fx_constraint_particle_collision;fx_constraint_particle_property;};
			}
		}
	}
	GROUP SUB_FXOBSTACLE_COUPLING
	{			
		GROUP SEP_FXOBSTACLE_COUPLING_SOLID
		{
			DEFAULT 1;
			REAL FXOBSTACLE_STRENGTH_TRANSLATION { MIN 0; MAXSLIDER 200; CUSTOMGUI REALSLIDER; UNIT PERCENT; }
			REAL FXOBSTACLE_STRENGTH_ROTATION { MIN 0; MAXSLIDER 200; CUSTOMGUI REALSLIDER; UNIT PERCENT; }
		}
		GROUP SEP_FXOBSTACLE_COUPLING_FLUID
		{
			DEFAULT 1;
			REAL FXOBSTACLE_STRENGTH_TRANSLATION_FLUID { MIN 0; MAXSLIDER 200; CUSTOMGUI REALSLIDER; UNIT PERCENT; }
			REAL FXOBSTACLE_STRENGTH_ROTATION_FLUID { MIN 0; MAXSLIDER 200; CUSTOMGUI REALSLIDER; UNIT PERCENT; }
		}
	}
	GROUP SUB_FXOBSTACLE_CACHE
	{		
		LINK FXOBSTACLE_CACHE_DURATION { ACCEPT {fx_duration;}}
		
		SEPARATOR {LINE;}

		BOOL FXOBSTACLE_CACHE_USE {}
		BOOL FXOBSTACLE_CACHE_SUBFRAMES {}
		BUTTON FXOBSTACLE_CACHE_CLEAR {}

		SEPARATOR SEP_FXOBSTACLE_CACHE_LOAD {}

		BOOL FXOBSTACLE_CACHE_LOAD {}
		REAL FXOBSTACLE_CACHE_OFFSET {}
	}
}